### 实验名称

多元回归分析及实战

### 实验目的

1、掌握基于jupyter notebook工具的使用，python基本语法、pandas、numpy、matplotlib等模块应用；

2、掌握基于sklearn构建回归算法的数据加载、数据预处理、模型构建、模型训练等基本的数据挖掘开发流程；

3、掌握回归算法的一元回归模型、二元回归模型及多元回归模型的构建、训练、评估及结果对比。

### 实验背景

1、通过对保险的相关数据，分析数据的特征、字段、格式以及相关性等因素，了解影响保险费用续费的关键性因素。

2、通过对比一元回归分析模型、二元回归分析模型及多元回归分析模型，找出影响保险续费的潜在因素及做相应预测。

### 实验原理

使用JupyterNotebook对数据进行处理和分析，涉及到python3的基础语法、pandas模块、numpy模块、matplotlib模块等python相关的数据分析库，各模块实现以下功能：

1，利用JupyterNotebook工具进行python3编程，数据读取、函数调用、显示图像数据。

2，通过pandas加载保险相关的数据insurance.csv，实现数据缺失值判断、格式转换等数据预处理操作。

3，通过sklearn实例化一元回归、二元回归及多元回归模型，并对数据进行训练，评估训练结果。

### 实验环境

Ubuntu 18.04

Python 3.9

jupyter notebook 6.1.0

pandas 2.0.3

matplotlib 3.7.2

numpy 1.25.2

sklearn 1.4.1

### **建议课时**

2课时

### 操作步骤

#### 1、导入相关库

（1）、打开terminal终端，下载源数据

```markup
cd ~
wget --restrict-file-names=nocontrol http://10.90.3.2/HUP/DataMining/2024/03/insurance.csv
```

（2）、启动jupyter

```markup
cd ~
jupyter notebook
```

（3）、新建python3文档

![01_加载数据预览.png](./pic/01_加载数据预览.png)

（4）、导入相关模块

```markup
# 导入需要的包
import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LinearRegression
from sklearn.metrics import mean_squared_error, r2_score
from sklearn.model_selection import cross_val_score, train_test_split
```

#### 2、数据加载

使用Python的pandas模块进行数据加载，示例代码如下：

```markup
#通过pd.read.csv（）读取数据
df = pd.read_csv("/home/ubuntu/insurance.csv", header=0)
df.head(10)
# age: 年龄
# gender:男性或女性
# bmi:人体重量指数
# no_of_children:子女数量
# smoker:是否抽烟
# region:属于美国的哪个区域：NW,NE,SW,SE
# charges:每年保险费用（美元）
```

![01_加载数据预览.png](./pic/01_加载数据预览.png)

#### 3、数据预处理

（1）、替换sex和smoker列的字符串

```markup
# 替换sex列的字符串
df.loc[df['sex']=='female',"sex"]=1
df.loc[df['sex']=='male',"sex"]=2
# 替换smoker列的字符串
df.loc[df['smoker']=='no',"smoker"]=0
df.loc[df['smoker']=='yes',"smoker"]=1
df.head()
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

（2）、替换region列的字符串

```markup
# 查看多少个区域
set(df['region'].to_list())
```

```markup
# 定义替换函数
def str_int(col):
    re=None
    if col=='northeast':
        re=0
    elif col=='northwest':
        re=1
    elif col=='southeast':
        re=2
    elif col=='southwest':
        re=3
    else:
        pass
    return re
# 替换region列的字符串
df['region']=df['region'].apply(lambda col:str_int(col))
df.head(10)
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

（3）、查看数据基本信息

```markup
# 查看数据基本信息
df.info()
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

（4）、判断是否有空值

```markup
# 判断是否有空值
df.isna().sum()
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

#### 4、构建一元回归模型

保险费用（Charges)与是否吸烟（Smoker)存在很强的正相关性，我们构建一元线性回归模型

```markup

# 获取特征数据和标签数据
X = df[['smoker']]
Y = df[['charges']]

# 实例化模型
lr = LinearRegression()

# 训练模型
lr.fit(X,Y)

# 评估模型
lr.score(X,Y)
 
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

#### 5、构建二元回归模型

为了使模型更精确，我们可以构建基于Age,Smoker与Charges之间构建二元回归模型

```markup
# 获取特征数据和标签数据
X1 = df[['age','smoker']]
Y1 = df[['charges']]

# 实例化模型
lr1 = LinearRegression()

# 训练模型
lr1.fit(X1,Y1)

# 评估模型
lr1.score(X1,Y1)	
 
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

#### 6、构建多元回归模型

为了使模型更精确，我们Charges设为标签，其他列设为特征，构建多元回归模型

```markup
# 切分数据集
y_data = df['charges']
x_data=df.drop('charges',axis=1)
x_train, x_test, y_train, y_test = train_test_split(x_data, y_data, test_size=0.20, random_state=1)

# 实例化模型
lr2 = LinearRegression()

# 训练模型
lr2.fit(x_train,y_train)

# 评估模型
lr2.score(x_test,y_test)
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

### 实验总结

本项目主要内容是使用jupyterNotebook对保险数据数据进行回归分析，首先用pandas对数据进行预处理，将各列的字符串替换成整型或浮点型，通过sklearn库直接实例化线性回归模型，并对比一元线性回归、二元线性回归和多元线性回归模型的训练结果。通过实操能够熟悉python编写数据分析过程，熟悉数据分析常用的模块pandas、numpy以及matplotlib模块，掌握基于sklearn的回归分析模型的预测的基本方法，能够使用sklearn库进行回归模型的建模、训练、预测及评估等操作。